﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.CIT" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    void OnContextLoad(object sender, EventArgs e) {
        CITST citst = (CITST)dc[typeof(CITST)];
        if (citst as CITST_7 == null)
            throw new InvalidOperationException("Wydruk CIT-ST (7) może być drukowany wyłącznie dla deklaracji CIT-ST w wersji 7.");
       
        var view = citst.Deklaracje.CreateView();
        view.Condition &= new FieldCondition.Equal("Typ", TypDeklaracji.CITSTM);
        Grid1.DataSource = view;

        string zal = "";
        view = citst.Deklaracje.CreateView();
        view.Condition &= new FieldCondition.Equal("Typ", TypDeklaracji.CITSTA);
        if (!view.IsEmpty) {
            CITSTA_5 citsta = (CITSTA_5)view.GetFirst();
            colNazwa.EditValue = citsta.Bloki["A"]["Nazwa"];
            colRegon.EditValue = citsta.Bloki["A"]["Regon"];
            Grid2.DataSource = citsta.Deklaracje;
            zal = "CIT-ST/A"; 
        }
        Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3 dek = (Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3)citst;
        if (dek.Visible)
            zal += (zal != "" ? ", " : "") + "ORD-ZU";
        colZalaczniki.EditValue = zal;
    }
</script>

<HTML>
	<HEAD>
		<TITLE>Informacja CIT-ST (7)</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CITST,Soneta.Deklaracje" oncontextload="OnContextLoad" Landscape="true"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" title="INFORMACJA CIT-ST (7), CIT-ST/A (5)|Za okres od {0} do {1}"
                DataMember0="0.Od" DataMember1="0.Do"></eb:ReportHeader>
            <font style="font-family: Verdana; font-size: 16px; font-weight: bold">CIT-ST</font>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">A. MIEJSCE SKŁADANIA INFORMACJI</font>
            <br />
            <table class="style1" style="font-family: Verdana; font-size: 11px; border-collapse: collapse;" border="1" width="100%">
                <tr>
                    <td width="28pt"><b>7.</b></td>
                    <td width="40%">Urząd skarbowy, do którego adresowana jest informacja</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel1" runat="server" DataMember="A.UrzadSkarb"></ea:DataLabel>
                    </td>
                </tr>
            </table>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">B. CEL I SPOSÓB SKŁADANIA INFORMACJI</font>
            <table class="style1" style="font-family: Verdana; font-size: 11px; border-collapse: collapse;" border="1" width="100%">
                <tr>
                    <td width="28pt"><b>8.</b></td>
                    <td>Cel złożenia informacji</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel2" runat="server" DataMember="B.Korekta">
                            <ValuesMap>
                                <ea:ValuesPair Key="False" Value="złożenie po raz pierwszy informacji za dany okres" />
                                <ea:ValuesPair Key="True" Value="korekta informacji za dany okres" />
                            </ValuesMap>
                        </ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>9.</b></td>
                    <td>Sposób składania</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel3" runat="server" DataMember="B.WTerminieZaliczki">
                            <ValuesMap>
                                <ea:ValuesPair Key="False" Value="z zeznianiem CIT-8" />
                                <ea:ValuesPair Key="True" Value="w terminie wpłaty zaliczki na podatek" />
                            </ValuesMap>
                        </ea:DataLabel>
                    </td>
                </tr>
            </table>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">D. INFORMACJA O LICZBIE ZATRUDNIONYCH</font>
            <table class="style1" style="font-family: Verdana; font-size: 11px; border-collapse: collapse;" border="1" width="100%">
                <tr>
                    <td width="28pt"><b>22.</b></td>
                    <td width="40%">Liczba zatrudnionych przez podatnika - ogółem</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel4" runat="server" DataMember="D.LiczbaZatrudnionych"></ea:DataLabel>
                    </td>
                </tr>
            </table>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">E. LICZBA ZATRUDNIONYCH W ZAKŁADACH (ODDZIAŁACH)</font>
            <ea:Grid id="Grid1" runat="server">
				<Columns>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa województwa" DataMember="E.Wojew"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa powiatu" DataMember="E.Powiat"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa gminy" DataMember="E.Gmina"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Kod gminy" DataMember="E.KodGminy"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa zakładu (oddziału)" DataMember="E.NazwaOddziału"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="REGON zakładu (oddziału)" DataMember="E.Regon"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="NIP zakładu (oddziału)" DataMember="E.NIP"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Liczba zatrudnionych w zakładzie (oddziale)" DataMember="E.LiczbaZatrudnionych"></ea:GridColumn>
				</Columns>
			</ea:Grid>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">F. OŚWIADCZENIE OSÓB ODPOWIEDZIALNYCH</font>
            <table class="style1" style="font-family: Verdana; font-size: 11px; border-collapse: collapse;" border="1" width="100%">
                <tr>
                    <td width="28pt"><b>167.</b></td>
                    <td width="40%">Imię i nazwisko osoby odpowiedzialnej za sporządzenie informacji</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel5" runat="server" DataMember="F.Imię"></ea:DataLabel>
                        &nbsp;
						<ea:DataLabel id="DataLabel6" runat="server" DataMember="F.Nazwisko"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>168.</b></td>
                    <td>Podpis osoby odpowiedzialnej za sporządzenie informacji</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel7" runat="server" DataMember="F.Podpis"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>169.</b></td>
                    <td>Data wypełnienia informacji</td>
                    <td align="center">
						<ea:DataLabel id="DataLabel8" runat="server" DataMember="F.Data"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>170.</b></td>
                    <td>Informacja o załącznikach</td>
                    <td align="center">
						<ea:DataLabel runat="server" id="colZalaczniki"></ea:DataLabel>
                    </td>
                </tr>
            </table>
            <br />
            <font style="font-family: Verdana; font-size: 16px; font-weight: bold">CIT-ST/A</font>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">A. DANE IDENTYFIKACYJNE PODATNIKA</font>
            <br />
            <table class="style1" style="font-family: Verdana; font-size: 11px; border-collapse: collapse;" border="1" width="100%">
                <tr>
                    <td width="28pt"><b>3.</b></td>
                    <td width="40%">Nazwa pełna</td>
                    <td align="center">
						<ea:DataLabel runat="server" id="colNazwa"></ea:DataLabel>
                    </td>
                </tr>
                <tr>
                    <td><b>4.</b></td>
                    <td>Numer identyfikacyjny REGON</td>
                    <td align="center">
						<ea:DataLabel runat="server" id="colRegon"></ea:DataLabel>
                    </td>
                </tr>
            </table>
            <br />
            <font style="font-family: Verdana; font-size: 11px; font-weight: bold">B. WYKAZ ZAKŁADÓW (ODDZIAŁÓW)</font>
            <ea:Grid id="Grid2" runat="server">
				<Columns>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa pełna" DataMember="B1.Nazwa"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa skrócona" DataMember="B1.NazwaSkrócona"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Regon" DataMember="B1.Regon"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="NIP" DataMember="B1.NIP"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Data rozpoczęcia działalności" DataMember="B1.DataRozpoczęciaDziałalności"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Kraj" DataMember="B2.Kraj"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Województwo" DataMember="B2.Wojew"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Powiat" DataMember="B2.Powiat"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Gmina" DataMember="B2.Gmina"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Ulica" DataMember="B2.Ulica"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nr domu" DataMember="B2.NrDomu"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nr lokalu" DataMember="B2.NrLokalu"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Miejscowość" DataMember="B2.Miejsc"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Kod pocztowy" DataMember="B2.KodPoczt"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Poczta" DataMember="B2.Poczta"></ea:GridColumn>
				</Columns>
			</ea:Grid>
            <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
